/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TbkRtaConsumerMatchResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TbkRtaConsumerMatchRequest
extends BaseTaobaoRequest<TbkRtaConsumerMatchResponse> {
    private Long adzoneId;
    private String deviceType;
    private String deviceValue;
    private String offerList;
    private String specialId;

    public void setAdzoneId(Long adzoneId) {
        this.adzoneId = adzoneId;
    }

    public Long getAdzoneId() {
        return this.adzoneId;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceValue(String deviceValue) {
        this.deviceValue = deviceValue;
    }

    public String getDeviceValue() {
        return this.deviceValue;
    }

    public void setOfferList(String offerList) {
        this.offerList = offerList;
    }

    public void setOfferList(List<OfferList> offerList) {
        this.offerList = new JSONWriter(false, true).write(offerList);
    }

    public String getOfferList() {
        return this.offerList;
    }

    public void setSpecialId(String specialId) {
        this.specialId = specialId;
    }

    public String getSpecialId() {
        return this.specialId;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.tbk.rta.consumer.match";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("adzone_id", (Object)this.adzoneId);
        txtParams.put("device_type", this.deviceType);
        txtParams.put("device_value", this.deviceValue);
        txtParams.put("offer_list", this.offerList);
        txtParams.put("special_id", this.specialId);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<TbkRtaConsumerMatchResponse> getResponseClass() {
        return TbkRtaConsumerMatchResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.adzoneId, "adzoneId");
        RequestCheckUtils.checkObjectMaxListSize(this.offerList, 100, "offerList");
    }

    public static class OfferList
    extends TaobaoObject {
        private static final long serialVersionUID = 8767253163841458421L;
        @ApiField(value="item_id")
        private String itemId;
        @ApiField(value="offer_id")
        private String offerId;
        @ApiField(value="tlj_url")
        private String tljUrl;

        public String getItemId() {
            return this.itemId;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public String getOfferId() {
            return this.offerId;
        }

        public void setOfferId(String offerId) {
            this.offerId = offerId;
        }

        public String getTljUrl() {
            return this.tljUrl;
        }

        public void setTljUrl(String tljUrl) {
            this.tljUrl = tljUrl;
        }
    }
}

