/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.sec.client.FastIPGeoClient;
import com.alibaba.sec.domain.FastGeoConf;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.ip.impl.aliyun.DataInfo;
import com.bxm.warcar.ip.impl.aliyun.DataServer;
import com.bxm.warcar.ip.impl.aliyun.FileCache;
import com.bxm.warcar.ip.impl.aliyun.GeoipProfile;
import com.bxm.warcar.ip.impl.aliyun.Summary;
import com.bxm.warcar.ip.impl.aliyun.Type;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class AliyunIpLibrary
extends LifeCycle
implements IpLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliyunIpLibrary.class);
    private final ScheduledExecutorService scheduled = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("upgrade"));
    private final String parentPath = System.getProperty("user.home") + File.separator + ".warcar" + File.separator;
    private final File summaryFile = new File(this.parentPath + "geoip.summary.json");
    private final GeoipProfile profile;
    private Summary summary = new Summary();
    private FastIPGeoClient fastIPGeoClient;
    private final DataServer dataServer;

    public AliyunIpLibrary(GeoipProfile profile, DataServer dataServer) {
        this.profile = profile;
        this.dataServer = dataServer;
    }

    public int getOrder() {
        return 0;
    }

    @Override
    protected void doInit() {
        this.mkdirParentIfNecessary(this.parentPath);
        this.downloadGeoipIfNecessary();
        this.refresh();
        if (this.profile.isAutoUpgrade()) {
            this.scheduled.scheduleWithFixedDelay(() -> {
                if (this.downloadGeoipIfNecessary()) {
                    this.refresh();
                }
            }, this.profile.getUpgradeInHours(), this.profile.getUpgradeInHours(), TimeUnit.HOURS);
        }
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    public IP find(String ip) {
        try {
            String search = this.fastIPGeoClient.search(ip);
            if (StringUtils.isNotBlank((String)search)) {
                Result result = JsonHelper.convert(search, Result.class);
                IP i = new IP();
                i.setCountry(result.getCountry());
                i.setCountrycode(result.getCountry_code());
                i.setProvince(result.getProvince());
                i.setCity(result.getCity());
                i.setCounty(result.getCounty());
                i.setIsp(result.getIsp());
                i.setIspcode(result.getIsp_code());
                i.setLongitude(result.getLongitude());
                i.setLatitude(result.getLatitude());
                i.setHitcode(this.findFirst(result.getCounty_code(), result.getCity_code(), result.getProvince_code()));
                return i;
            }
        }
        catch (Exception e) {
            LOGGER.error("findIp: " + ip, (Throwable)e);
        }
        return null;
    }

    @Override
    public synchronized void refresh() {
        try {
            long start = System.currentTimeMillis();
            FastGeoConf geoConf = new FastGeoConf();
            geoConf.setDataFilePath(this.summary.getProfile().get((Object)Type.IPV4_DATA_TRACE).getPath());
            geoConf.setLicenseFilePath(this.summary.getProfile().get((Object)Type.LICENSE).getPath());
            HashSet<String> set = new HashSet<String>(Arrays.asList("country", "country_code", "province", "province_code", "city", "city_code", "county", "county_code", "isp", "isp_code", "routes", "longitude", "latitude"));
            geoConf.setProperties(set);
            geoConf.filterEmptyValue();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Ip library (aliyun) loading...");
            }
            this.fastIPGeoClient = new FastIPGeoClient(geoConf);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Ip library (aliyun) load finished in {} ms", (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("refresh: ", e);
        }
    }

    private String findFirst(String ... array) {
        for (String s : array) {
            if (!StringUtils.isNotBlank((String)s) || "null".equalsIgnoreCase(s)) continue;
            return s;
        }
        return null;
    }

    private boolean downloadGeoipIfNecessary() {
        try {
            String json;
            String string = json = this.summaryFile.exists() ? this.readFile(this.summaryFile) : null;
            if (StringUtils.isNotBlank((String)json)) {
                this.summary = JsonHelper.convert(json, Summary.class);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Aliyun Geoip summary: {}", (Object)JSONObject.toJSONString((Object)this.summary));
        }
        if (!this.summary.isEmpty() && !this.profile.isAutoUpgrade()) {
            return false;
        }
        try {
            boolean updated = false;
            Map<Type, DataInfo> dataInfos = this.dataServer.getDataInfos();
            for (Map.Entry<Type, DataInfo> dataInfo : dataInfos.entrySet()) {
                Type key = dataInfo.getKey();
                String remoteVersion = dataInfo.getValue().getVersion();
                Map<Type, FileCache> profile = this.summary.getProfile();
                FileCache fileCache = profile.get((Object)key);
                String currentVersion = Objects.isNull(fileCache) ? null : fileCache.getVersion();
                if (StringUtils.equals((String)currentVersion, (String)remoteVersion)) continue;
                LOGGER.info("[{}] discovering different versions, current is {}, remote is {}", new Object[]{key, currentVersion, remoteVersion});
                String downloadUrl = this.dataServer.getUrl(key);
                if (StringUtils.isBlank((String)downloadUrl)) continue;
                byte[] bytes = this.downloadFile(downloadUrl);
                String fileName = StringUtils.defaultIfBlank((String)this.getFileNameOnDownloadUrl(downloadUrl), (String)(key.name() + "_" + remoteVersion));
                File file = new File(this.parentPath + fileName);
                this.checkAndCreateFile(file);
                this.writeDataToFile(file, bytes);
                profile.put(key, new FileCache(file.getPath(), remoteVersion));
                updated = true;
            }
            if (updated) {
                this.writeDataToFile(this.summaryFile, JsonHelper.convert2bytes(this.summary));
            }
            return updated;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getFileNameOnDownloadUrl(String downloadUrl) {
        UriComponents build = UriComponentsBuilder.fromUriString((String)downloadUrl).build();
        List pathSegments = build.getPathSegments();
        return (String)pathSegments.get(pathSegments.size() - 1);
    }

    private void mkdirParentIfNecessary(String parent) {
        File directory = new File(parent);
        if (!directory.exists()) {
            boolean mkdirs = directory.mkdirs();
            if (!mkdirs) {
                throw new RuntimeException(parent + " cannot run command: mkdirs!");
            }
        } else if (!directory.isDirectory()) {
            throw new RuntimeException(parent + " is not directory!");
        }
    }

    private void checkAndCreateFile(File file) {
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new RuntimeException("Cannot create file: " + file);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Created file: {}", (Object)file);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("createNewFile: ", e);
            }
        }
        if (!file.isFile()) {
            throw new RuntimeException("File must be not directory: " + file);
        }
    }

    private String readFile(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    private void writeDataToFile(File file, byte[] data) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])data);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Data {} bytes write to file {} successful.", (Object)data.length, (Object)file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] downloadFile(String url) {
        byte[] byArray;
        HttpURLConnection urlConnection = null;
        InputStream inputStream = null;
        ByteArrayOutputStream os = null;
        try {
            int len;
            urlConnection = (HttpURLConnection)new URL(url).openConnection();
            inputStream = urlConnection.getInputStream();
            int length = urlConnection.getHeaderFieldInt("Content-Length", -1);
            int available = length > 0 ? length : inputStream.available();
            long start = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{} Starting download, The content length is {}...", (Object)url, (Object)available);
            }
            os = new ByteArrayOutputStream(available);
            byte[] buffer = new byte[0x3200000];
            while ((len = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            os.flush();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{} Finished in {} ms!", (Object)url, (Object)(System.currentTimeMillis() - start));
            }
            byArray = os.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("getLicense: ", (Throwable)e);
                }
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                if (null != urlConnection) {
                    urlConnection.disconnect();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
            return byArray2;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        if (null != urlConnection) {
            urlConnection.disconnect();
        }
        return byArray;
    }

    private static class Result
    implements Serializable {
        private static final long serialVersionUID = -4731354983202603658L;
        private String country;
        private String country_code;
        private String province;
        private String province_code;
        private String city;
        private String city_code;
        private String county;
        private String county_code;
        private String isp;
        private String isp_code;
        private String routes;
        private String longitude;
        private String latitude;

        private Result() {
        }

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getCountry_code() {
            return this.country_code;
        }

        public void setCountry_code(String country_code) {
            this.country_code = country_code;
        }

        public String getProvince() {
            return this.province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getProvince_code() {
            return this.province_code;
        }

        public void setProvince_code(String province_code) {
            this.province_code = province_code;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getCity_code() {
            return this.city_code;
        }

        public void setCity_code(String city_code) {
            this.city_code = city_code;
        }

        public String getCounty() {
            return this.county;
        }

        public void setCounty(String county) {
            this.county = county;
        }

        public String getCounty_code() {
            return this.county_code;
        }

        public void setCounty_code(String county_code) {
            this.county_code = county_code;
        }

        public String getIsp() {
            return this.isp;
        }

        public void setIsp(String isp) {
            this.isp = isp;
        }

        public String getIsp_code() {
            return this.isp_code;
        }

        public void setIsp_code(String isp_code) {
            this.isp_code = isp_code;
        }

        public String getRoutes() {
            return this.routes;
        }

        public void setRoutes(String routes) {
            this.routes = routes;
        }

        public String getLongitude() {
            return this.longitude;
        }

        public void setLongitude(String longitude) {
            this.longitude = longitude;
        }

        public String getLatitude() {
            return this.latitude;
        }

        public void setLatitude(String latitude) {
            this.latitude = latitude;
        }
    }
}

