#!/bin/bash

ACTIVE="test"
echo "Use default profile: $ACTIVE"

[ ! -d ~/run/ ] && mkdir -p ~/run

if [ -f ~/run/adscounter-ocpx.pid ]; then
  echo "Server [adscounter-ocpx] pid file has been exists!";
  exit
fi


HEAP_MEMORY=512m
SERVER_JAR=`ls ../lib/adscounter-ocpx-1.18.4.jar`

exec "${JAVA_HOME}/bin/java" -server -Dspring.profiles.active=$ACTIVE -Xms${HEAP_MEMORY} -Xmx${HEAP_MEMORY} -XX:+HeapDumpOnOutOfMemoryError -jar ${SERVER_JAR} >/dev/null 2>&1 & echo $! > ~/run/adscounter-ocpx.pid