#!/bin/bash

if [ ! -f ~/run/adscounter-ocpx.pid ]; then
  echo "Server [adscounter-ocpx] doest not started!"
  exit
fi

pid=`cat ~/run/adscounter-ocpx.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in adscounter-ocpx.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [adscounter-ocpx] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 60 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [adscounter-ocpx] cannot stop, Please check pid file 'adscounter-ocpx.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [adscounter-ocpx] has been stoped!"
fi

rm -f ~/run/adscounter-ocpx.pid