package com.bxm.adscounter.rtb.common;

import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.data.Parameter;

import java.util.List;

/**
 * RTB 数据获取器。
 * 该接口可以通过调用 RTB 平台的API接口来获取相关数据。
 *
 * @author allen
 * @date 2022-11-15
 * @since 1.0
 */
public interface DataFetcher {

    /**
     * RTB 平台
     * @return RTB
     */
    Rtb rtb();

    /**
     * 获取当前小时的广告组数据
     *
     * @param parameter 自定义请求参数
     *
     * @return 数据结果集
     * @throws DataFetchFailException 数据获取失败的异常
     */
    List<AdGroupData> fetchCurrentHourData(Parameter parameter) throws DataFetchFailException;

    /**
     * 获取上个小时的广告组数据，如果是 0点时，会获取昨日 23点数据。
     *
     * @param parameter 自定义请求参数
     *
     * @return 数据结果集
     * @throws DataFetchFailException 数据获取失败的异常
     */
    List<AdGroupData> fetchPreviousHourData(Parameter parameter) throws DataFetchFailException;
}
