package com.bxm.adscounter.rtb.common;

import com.bxm.adscounter.rtb.common.service.FeedbackService;
import com.google.common.collect.Maps;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

import java.util.Map;
import java.util.Objects;

/**
 * @author allen
 * @date 2022-05-13
 * @since 1.0
 */
public class RtbIntegrationFactory implements BeanPostProcessor {

    private final Map<Rtb, RtbIntegration> mapping = Maps.newHashMap();
    private final Map<Rtb, DataFetcher> dataFetcherMap = Maps.newHashMap();
    private final Map<Rtb, FeedbackService> feedbackServiceMap = Maps.newHashMap();

    public RtbIntegration get(Rtb rtb) {
        return mapping.get(rtb);
    }

    public DataFetcher getDataFetcher(Rtb rtb) {
        return dataFetcherMap.get(rtb);
    }

    public FeedbackService getFeedbackService(Rtb rtb) {
        return feedbackServiceMap.get(rtb);
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RtbIntegration) {
            RtbIntegration integ = (RtbIntegration) bean;
            RtbIntegration exists = mapping.put(integ.rtb(), integ);
            check(exists, integ, integ.rtb());
        }
        if (bean instanceof DataFetcher) {
            DataFetcher fetcher = (DataFetcher) bean;
            DataFetcher exists = dataFetcherMap.put(fetcher.rtb(), fetcher);
            check(exists, fetcher, fetcher.rtb());
        }
        if (bean instanceof FeedbackService) {
            FeedbackService feedbackService = (FeedbackService) bean;
            FeedbackService exists = feedbackServiceMap.put(feedbackService.getRtb(), feedbackService);
            check(exists, feedbackService, feedbackService.getRtb());
        }
        return bean;
    }

    private void check(Object exists, Object n, Rtb rtb) {
        if (Objects.nonNull(exists)) {
            throw new RuntimeException("Registering [" + rtb + "] bean " + n + " but has been exists! " + exists);
        }
    }
}
