package com.bxm.adscounter.rtb.common;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author allen
 * @date 2022-05-13
 * @since 1.0
 */
@Data
@ConfigurationProperties(prefix = "rtb")
public class RtbProperties {

    /**
     * OpenLog 内网请求地址
     */
    private String openLogRequestDomain = "http://openlog.bianxianmao.com";

    /**
     * 用来通知消息或报警的钉钉URL
     */
    private String notifyDingtalkUrl = "https://oapi.dingtalk.com/robot/send?access_token=286c319d5372a26356c61106c129286a5535269896273bc0857d57d576c7ba62";

    /**
     * 是否开启rtb控量控制
     * true是，false否
     */
    private String enableRateControl = "false";

    /**
     * 是否开启累加回传智能托管定时任务
     */
    private String enableSmartHostingScheduler = "false";

    /**
     * 是否开启rtb补量控制
     * true是，false否
     */
    private String enablePlusControl = "false";
}
