package com.bxm.adscounter.rtb.common.autoconfigure;

import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouConfig;
import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouDataFetcher;
import com.bxm.warcar.cache.Fetcher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @date 2022-11-15
 * @since 1.0
 */
public class DataFetcherAutoConfigration {

    private final JedisPool jedisPool;
    private final Fetcher fetcher;

    public DataFetcherAutoConfigration(@Qualifier("rtbJedisPool") JedisPool jedisPool, Fetcher fetcher) {
        this.jedisPool = jedisPool;
        this.fetcher = fetcher;
    }

    @Bean
    public KuaishouDataFetcher kuaishouDataFetcher(KuaishouConfig config) {
        return new KuaishouDataFetcher(config, jedisPool, fetcher);
    }
}
