package com.bxm.adscounter.rtb.common.autoconfigure;

import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @date 2022-07-13
 * @since 1.0
 */
@EnableConfigurationProperties(RtbJedisProperties.class)
public class RtbJedisAutoConfiguration {

    private final RtbJedisProperties properties;

    public RtbJedisAutoConfiguration(RtbJedisProperties properties) {
        this.properties = properties;
    }

    @Bean(name = "rtbJedisPool")
    public JedisPool rtbJedisPool() {
        return new JedisPool(properties, properties.getHost(), properties.getPort(), properties.getTimeout(), properties.getPassword(), properties.getDatabase());
    }

    @Bean(name = "rtbJedisFetcher")
    public JedisFetcher rtbJedisFetcher() {
        return new JedisFetcher(rtbJedisPool());
    }

    @Bean(name = "rtbJedisUpdater")
    public JedisUpdater rtbJedisUpdater() {
        return new JedisUpdater(rtbJedisPool());
    }

    @Bean(name = "rtbJedisCounter")
    public JedisCounter rtbJedisCounter() {
        return new JedisCounter(rtbJedisPool());
    }
}

