package com.bxm.adscounter.rtb.common.control;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.warcar.integration.eventbus.EventPark;
import lombok.extern.slf4j.Slf4j;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @date 2022-07-14
 * @since 1.0
 */
@Slf4j
public abstract class AbstractStandaloneControlScheduler implements Runnable {

    private final RtbIntegration instance;
    private final JedisPool jedisPool;
    private final EventPark eventPark;

    public AbstractStandaloneControlScheduler(RtbIntegration instance, JedisPool jedisPool, EventPark eventPark) {
        this.instance = instance;
        this.jedisPool = jedisPool;
        this.eventPark = eventPark;
    }

    /**
     * 执行任务
     */
    protected abstract void doRun();

    @Override
    public void run() {
        try {
            doRun();
        } catch (Exception e) {
            log.error("doRun: ", e);
        }
    }

    public RtbIntegration getInstance() {
        return instance;
    }

    public JedisPool getJedisPool() {
        return jedisPool;
    }

    public EventPark getEventPark() {
        return eventPark;
    }
}
