package com.bxm.adscounter.rtb.common.control;

import org.apache.commons.lang.StringUtils;

/**
 * @author allen
 * @date 2022-07-15
 * @since 1.0
 */
public class ControlUtils {

    public static final String KEY_SPLIT_CHAR = "_";

    public static String[] splitKey(String string) {
        return StringUtils.split(string, KEY_SPLIT_CHAR);
    }

    /**
     * 按指定字符串数组创建一个 s_s_s_n 格式的 Key
     * @param strings 字符串数组
     * @return Key
     */
    public static String createKey(String...strings) {
        StringBuilder s = new StringBuilder();
        for (String string : strings) {
            s.append(string.replaceAll(":", "")).append(KEY_SPLIT_CHAR);
        }
        return StringUtils.removeEnd(s.toString(), KEY_SPLIT_CHAR);
    }
}
