package com.bxm.adscounter.rtb.common.control;

import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.mapper.SrcAdUserAccessLogMapper;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.TypeHelper;
import lombok.extern.slf4j.Slf4j;
import redis.clients.jedis.JedisPool;

import java.util.List;

/**
 * @author allen
 * @date 2022-07-13
 * @since 1.0
 */
@Slf4j
@Deprecated
public class DefaultActivityRateControlRtbIntegrationImpl extends AbstractRateControlRtbIntegration {

    public static final String conv_type_activity_attend = "1";
    public static final String conv_type_activity_reattend = "2";


    public DefaultActivityRateControlRtbIntegrationImpl(JedisPool jedisPool, PositionRtbService service, EventPark eventPark, RtbIntegrationFactory rtbIntegrationFactory, SrcAdUserAccessLogMapper srcAdUserAccessLogMapper) {
        super(jedisPool, service, eventPark, rtbIntegrationFactory, srcAdUserAccessLogMapper);
    }

    @Override
    protected String createControlKey(String tagId, String adId, String adGroupId, PositionRtb.SpeedControl cfg) {
        return ControlUtils.createKey(tagId, adGroupId, cfg.getConvType(), TypeHelper.castToString(cfg.getId()), cfg.getDate(), cfg.getStartTime(), cfg.getEndTime());
    }

    @Override
    protected String createReferencedKey(String tagId, String adId, String adGroupId, PositionRtb.SpeedControl cfg) {
        return tagId + adGroupId + cfg.getConvType();
    }

    @Override
    protected List<PositionRtb.SpeedControl> chooseControls(PositionRtb config) {
        return config.getActivityControls();
    }

    @Override
    protected ActionType getActionType(PositionRtb.SpeedControl cfg) {
        if (conv_type_activity_attend.equals(cfg.getConvType())) {
            return ActionType.ACTIVITY_ATTEND;
        }
        if (conv_type_activity_reattend.equals(cfg.getConvType())) {
            return ActionType.ACTIVITY_REATTEND;
        }
        return null;
    }
}
