package com.bxm.adscounter.rtb.common.control;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @author allen
 * @date 2022-07-13
 * @since 1.0
 */
@Slf4j
public class LocalDateTimeUtils {

    public static LocalDate parseDate(String date) {
        if (StringUtils.isBlank(date)) {
            log.error("date is null");
            return null;
        }
        try {
            return LocalDate.from(DateTimeFormatter.ofPattern("yyyy-MM-dd").parse(date));
        } catch (Exception e) {
            log.error("from: {}", e.getMessage());
            return null;
        }
    }

    public static LocalTime parseTime(String time) {
        if (StringUtils.isBlank(time)) {
            log.error("time is null");
            return null;
        }
        try {
            return LocalTime.from(DateTimeFormatter.ofPattern("HH:mm:ss").parse(time));
        } catch (Exception e) {
            log.error("from: {}", e.getMessage());
            return null;
        }
    }

    public static LocalDateTime of(long timeInMillis) {
        return Instant.ofEpochMilli(timeInMillis).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}
