package com.bxm.adscounter.rtb.common.control;

import com.bxm.adscounter.rtb.common.ClickTracker;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.openlog.sdk.KeyValueMap;
import io.micrometer.core.instrument.binder.MeterBinder;

/**
 * @author allen
 * @date 2022-07-12
 * @since 1.0
 */
public interface RatioControlRtbIntegration extends MeterBinder {

    /**
     * 执行点击
     *
     * @param instance 回传集成实例
     * @param clickTrackerKeyValueMap 点击监测链接被请求的行为日志
     * @param adGroupId 广告组ID，RTB平台的，临时这样定义，后期需要兼容多个平台。
     * @see #onClick(RtbIntegration, KeyValueMap, String, String)
     */
    @Deprecated
    void onClick(RtbIntegration instance, KeyValueMap clickTrackerKeyValueMap, String adGroupId);

    /**
     * 执行点击
     *
     * @param instance 回传集成实例
     * @param clickTrackerKeyValueMap 点击监测链接被请求的行为日志
     * @param adGroupId 广告组ID，RTB平台的，临时这样定义，后期需要兼容多个平台。
     * @param app 媒体标识，如果为空则默认 {@link ClickTracker#EMPTY_APP}
     */
    void onClick(RtbIntegration instance, KeyValueMap clickTrackerKeyValueMap, String adGroupId, String app);

    /**
     * 执行券点击，只有在头部、助力券组里的才会被执行。
     *
     * @param instance 回传集成实例
     * @param clickTrackerKeyValueMap 点击监测事件
     * @param clickKeyValueMap 券点击事件
     * @param adGroupId 广告组ID，RTB平台的，临时这样定义，后期需要兼容多个平台。
     * @param app 媒体标识
     */
    void onTicketClick(RtbIntegration instance, KeyValueMap clickTrackerKeyValueMap, KeyValueMap clickKeyValueMap, String adGroupId, String app);

    /**
     * 执行回传的控制
     *
     * @param instance 回传集成实例
     * @param request 请求
     * @return 如果返回 true 则表示该回传被控制，内部线程会择机回传。如果返回 false，请继续执行回传逻辑。
     */
    boolean onFeedbackControl(RtbIntegration instance, FeedbackRequest request);
}
