package com.bxm.adscounter.rtb.common.control.cpa;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;

import java.util.List;

/**
 * cpa累加模式控制
 * @author tangxiao
 * @date 2023/6/8
 * @since 1.0
 */
public interface CpaControl {

    /**
     * 是否回传
     * @return
     */
    boolean isFeedback(FeedbackRequest feedbackRequest, RtbIntegration rtbIntegration);

    List<FeedbackRequest> getOnConversionQueue(String positionId, List<String> adGroupIds, Integer size);

    /**
     * 暂存回传请求
     * @param feedbackRequest
     */
    void pushConversion(FeedbackRequest feedbackRequest);

    long getConversionQueueLength(String positionId, List<String> adGroupIds);

    Long getSummaryCpaBalance(String positionId, String adGroupId);
}
