package com.bxm.adscounter.rtb.common.control.deduction;

import com.bxm.adscounter.rtb.common.control.ratio.RedisRatioControlImpl;

/**
 * 回传扣量控制器。
 *
 * @author tangxiao
 * @date 2022-08-05
 * @since 1.0
 * @see RedisRatioControlImpl
 */
@Deprecated
public interface DeductionControl {

    /**
     * 执行一次回传
     */
    void accept();

    /**
     * 拒绝（扣量）一次回传
     * @param data 用来标记本次的数据
     */
    void reject(String data);

    /**
     * 暂存数据。
     *
     * @param data 用来标记本次的数据
     */
    void push(String data);

    /**
     * 将删除所有历史数据。
     */
    void delete();

    /**
     * 获取控制器的配置。
     * @return 配置
     */
    DeductionControlConfig getConfig();
}
