package com.bxm.adscounter.rtb.common.control.deduction;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.function.Consumer;

/**
 * 速率调控配置。
 *
 * @author tangxiao
 * @date 2022-08-05
 * @since 1.0
 */
@Data
@Accessors(chain = true)
@Deprecated
public class DeductionControlConfig {

    /**
     * <p>维度，全局唯一。一般可以是广告ID、广告位等。</p>
     */
    private String dimension;

    /**
     * <p>转化的扣量比例。1 表示 100%。</p>
     */
    private double ratio = 1;

    /**
     * <p>当回传被执行时会调用这个消费者，传入的参数是 {@link DeductionControl#push(String)} 时的入参值。</p>
     * <p>请保证消费成功，如果失败请自己实现重试逻辑。</p>
     */
    private Consumer<String> consumer;

    /**
     * 当前命中控制配置的id
     */
    private Long hitConfigId;

    /**
     * 转化级别
     */
    private ConversionLevel level = ConversionLevel.SHALLOW;

    /**
     * 扣量时调用这个消费者
     */
    private Consumer<String> deductionConsumer;
}
