package com.bxm.adscounter.rtb.common.control.plus;

import com.bxm.adscounter.rtb.common.control.rate.RateControlConfig;

/**
 * 补量控制器。
 *
 * @author tangxiao
 * @date 2024-03-28
 * @since 1.0
 */
public interface PlusControl {

    /**
     * 开始速率控制。
     */
    void start();

    /**
     * 关闭速率控制。
     */
    void shutdown();

    /**
     * 计数 1 次。
     * @see #getCount()
     */
    void count();

    /**
     * 计数广告组1次，仅限EVERY维度
     * @param adGroupId
     */
    void countAdGroup(String adGroupId);

    /**
     * 获取已处理的次数。
     *
     * @return 次数
     * @see #count()
     */
    int getCount();

    /**
     * 暂存数据。
     *
     * @param id 用来标记本次数据的 ID，比如：bxm_id
     */
    void push(String id);

    /**
     * 刷新。
     */
    void refresh();

    /**
     * 将删除所有历史数据。
     */
    void delete();

    /**
     * 获取控制器的配置。
     * @return 配置
     */
    PlusControlConfig getConfig();
}
