package com.bxm.adscounter.rtb.common.control.plus;

import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.Consumer;

/**
 * 速率调控配置。
 *
 * @author allen
 * @date 2022-07-13
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class PlusControlConfig {

    /**
     * <p>维度，全局唯一。一般可以是广告ID、广告位等。</p>
     */
    private String dimension;

    /**
     * 后台配置id
     */
    private Integer controlId;

    /**
     * <p>开始时间</p>
     */
    private String date;

    /**
     * <p>结束时间</p>
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * <p>期望的总数。</p>
     */
    private int limit;

    /**
     * 每n分钟回传
     */
    private Integer n;

    /**
     * 每次回传y个
     */
    private Integer y;

    /**
     * 回传消费者
     */
    private Consumer<FeedbackRequest> consumer;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 平台广告组id
     */
    private String adGroupId;

    private PositionRtb positionRtb;

    /**
     * 历史数据回传时的ActionType
     */
    private ActionType actionType;

    /**
     * 广告id
     */
    private String adId;

    public boolean isUpdate(long limit) {
        return getLimit() != limit;
    }

    public String toSimpleString() {
        return "PlusControlConfig{" +
                "date=" + date +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", limit=" + limit +
                '}';
    }

    public boolean notInTime(Long timestamp) {
        LocalDateTime startLocalDate = LocalDateTime.parse(startTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime endLocalDate = LocalDateTime.parse(endTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime createDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        return createDateTime.isBefore(startLocalDate) || createDateTime.isAfter(endLocalDate);
    }

    public boolean isEveryGroupDimension() {
        return Objects.equals(adGroupId, "");
    }

    public boolean isTotalDimension() {
        return Objects.equals(adGroupId, "0");
    }
}
