package com.bxm.adscounter.rtb.common.control.plus;

import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;

import java.util.List;

/**
 * 补量控制回传队列
 * @author tangxiao
 * @date 2023/6/8
 * @since 1.0
 */
public interface PlusQueueService {

    /**
     * 存储回传请求,补量控制时使用
     * @param feedbackRequest
     */
    void pushConversion(FeedbackRequest feedbackRequest);

    /**
     * 获取回传请求
     *
     * @param positionId
     * @param adGroupIds
     * @param size
     * @param startTime
     * @param endTime
     * @return
     */
    List<FeedbackRequest> getOnConversionQueue(String positionId, List<String> adGroupIds, Integer size, String startTime, String endTime);
}
