package com.bxm.adscounter.rtb.common.control.plus.listener;

import com.bxm.adscounter.integration.adsmanager.AdsmanagerService;
import com.bxm.adscounter.rtb.common.control.plus.PlusControlConfig;
import com.bxm.adscounter.rtb.common.control.plus.event.PlusNotEnoughEvent;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.time.Duration;

/**
 * @author allen
 * @date 2022-10-18
 * @since 1.0
 */
@Slf4j
public class PlusNotEnoughEventListener implements EventListener<PlusNotEnoughEvent> {
    private static final int EXPIRE_TIME = Math.toIntExact(Duration.ofDays(7).getSeconds());

    private final AdsmanagerService adsmanagerService;
    private final Updater updater;

    public PlusNotEnoughEventListener(AdsmanagerService adsmanagerService, Updater updater) {
        this.adsmanagerService = adsmanagerService;
        this.updater = updater;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(PlusNotEnoughEvent event) {
        PlusControlConfig config = event.getConfig();
        Integer controlId = config.getControlId();

        // 设置标识
        updater.update(strPlusTips(config.getDimension()), "补量来源不够", EXPIRE_TIME);
        // 关闭状态
        if (isAllow(controlId)) {
            adsmanagerService.updatePlusControlStatus(controlId, 0);
            log.info("PlusNotEnoughEventListener consume controlId: {}", controlId);
        } else {
            log.info("PlusNotEnoughEventListener consume controlId: {} is not allow", controlId);
        }
    }

    public static KeyGenerator strPlusTips(String dimension) {
        return () -> KeyBuilder.build("rtb_control", "plus","tips", dimension);
    }

    private boolean isAllow(Integer controlId) {
        JedisPool jedisPool = (JedisPool) updater.getClientOriginal();
        try (Jedis jedis = jedisPool.getResource()) {
            String key = "plus_not_enough_update_lock_"+ controlId;
            Long v = jedis.incr(key);
            if (v == 1) {
                jedis.expire(key, 300);
                return true;
            }
            return false;
        }
    }
}
