package com.bxm.adscounter.rtb.common.control.rate;

import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalTime;
import java.util.function.Consumer;

/**
 * 速率调控配置。
 *
 * @author allen
 * @date 2022-07-13
 * @since 1.0
 */
@Data
@Accessors(chain = true)
@Deprecated
public class RateControlConfig {

    /**
     * <p>维度，全局唯一。一般可以是广告ID、广告位等。</p>
     */
    private String dimension;

    /**
     * <p>开始时间</p>
     */
    private LocalTime start;

    /**
     * <p>结束时间</p>
     */
    private LocalTime end;

    /**
     * <p>期望的总数。</p>
     */
    private long count;

    /**
     * <p>按照期望的比率，得出需要处理的数据。入参是：FeedbackRequest对象</p>
     * <p>内部调用这个消费者后，会立刻对分母计数。请保证消费成功，如果失败请自己实现重试逻辑。</p>
     */
    private Consumer<FeedbackRequest> consumer;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 平台广告组id
     */
    private String adGroupId;

    /**
     * <p>分母暂存数据过期时间，单位：小时，默认：24 小时。</p>
     * <p>设置时间越长，占用内存空间越大；时间越短，有效性越差。</p>
     */
    private long expireInHours = 24;

    private PositionRtb positionRtb;

    /**
     * 历史数据回传时的ActionType
     */
    private ActionType actionType;

    /**
     * 广告id
     */
    private String adId;

    public boolean isUpdate(long count, LocalTime start, LocalTime end) {
        return getCount() != count
                || !getStart().equals(start)
                || !getEnd().equals(end);
    }

    public String toSimpleString() {
        return "RateControlConfig{" +
                "start=" + start +
                ", end=" + end +
                ", count=" + count +
                '}';
    }
}
