package com.bxm.adscounter.rtb.common.control.ratio.event;

import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;

import java.util.EventObject;

/**
 * @author allen
 * @date 2022-10-19
 * @since 1.0
 */
public abstract class AbstractRatioEvent extends EventObject {

    private final RatioControl control;
    private final String adGroupId;
    private final String app;

    public AbstractRatioEvent(Object source, RatioControl control, String adGroupId, String app) {
        super(source);
        this.control = control;
        this.adGroupId = adGroupId;
        this.app = app;
    }

    /**
     * 返回发送 OpenLog 日志时的行为工作类型。
     * @return -1 时表示不发送
     */
    public abstract int getActionTypeForOpenLog();

    public RatioControl getControl() {
        return control;
    }

    public String getAdGroupId() {
        return adGroupId;
    }

    public String getApp() {
        return app;
    }
}
