package com.bxm.adscounter.rtb.common.control.ratio.event;

import com.bxm.adscounter.rtb.common.control.ratio.ClickLog;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;

import java.util.Objects;

/**
 * 回传给RTB平台成功事件
 *
 * @author allen
 * @date 2022-10-18
 * @since 1.0
 */
public class RatioFeedbackEvent extends AbstractRatioEvent {

    private final ClickLog clickLog;

    public RatioFeedbackEvent(Object source, RatioControl control, String adGroupId, String app, ClickLog clickLog) {
        super(source, control, adGroupId, app);
        this.clickLog = clickLog;
    }

    @Override
    public int getActionTypeForOpenLog() {
        return 2;
    }

    public boolean isFromClick() {
        return Objects.nonNull(clickLog);
    }

    public ClickLog getClickLog() {
        return clickLog;
    }
}
