package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.event.AdGroupFetchEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

/**
 * 广告组数据获取后控制器处理
 *
 * @author allen
 * @date 2022-11-16
 * @since 1.0
 */
public class AdGroupFetchControlHandleEventListener implements EventListener<AdGroupFetchEvent> {

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdGroupFetchEvent event) {
        RatioControl control = event.getControl();
        if (event.isRealTimeData()) {
            control.pushData(event.getAdGroupData());
            control.cleanX();
        }
    }
}
