package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.adscounter.rtb.common.DataFetchFailException;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.control.ratio.event.AdGroupFetchExceptionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.dingding.DingDingMessageSender;
import lombok.extern.slf4j.Slf4j;

/**
 * @author allen
 * @date 2022-11-18
 * @since 1.0
 */
@Slf4j
public class AdGroupFetchExceptionNotifyEventListener implements EventListener<AdGroupFetchExceptionEvent> {

    private final DingDingMessageSender messageSender;

    public AdGroupFetchExceptionNotifyEventListener(RtbProperties properties) {
        this.messageSender = new DingDingMessageSender(properties.getNotifyDingtalkUrl());
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdGroupFetchExceptionEvent event) {
        DataFetchFailException exception = event.getException();

        log.error("RTB数据获取失败！", exception);

        try {
            messageSender.send(new Message(exception.getMessage()));
        } catch (Exception e) {
            log.error("send: ", e);
        }
    }
}
