package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.event.AdGroupFetchEvent;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * 广告组数据获取后发送给 OpenLog
 *
 * @author allen
 * @date 2022-11-15
 * @since 1.0
 */
public class AdGroupFetchOpenLogEventListener implements EventListener<AdGroupFetchEvent> {

    private final RtbProperties properties;
    private final OpenLogClient openLogClient;

    public AdGroupFetchOpenLogEventListener(RtbProperties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdGroupFetchEvent event) {
        RatioControl control = event.getControl();
        RatioControlConfig config = control.getConfig();
        String tagId = config.getTagId();
        Rtb rtb = control.getBus().getInstance().rtb();
        String adGroupId = config.getAdGroupId();

        List<AdGroupData> dataList = event.getAdGroupData();
        if (CollectionUtils.isNotEmpty(dataList)) {
            dataList.forEach(e -> {
                KeyValueMap map = new KeyValueMap();

                map.put(Common.RtbParam.P, Production.COMMON.getName());
                map.put(Common.RtbParam.MT, Common.Mt.RtbAdGroupDataFetch.original());
                map.put(Common.RtbParam.TAGID, tagId);
                map.put(Common.Param.RTB_ID, rtb.getType());
                map.put(Common.Param.AD_GROUP_ID, adGroupId);
                map.put(Common.RtbParam.TIME, System.currentTimeMillis());
                map.put("date", e.getDate());
                map.put("hour", e.getHour());
                map.put("charge", e.getCharge());
                map.put("shallow_conv_count", e.getShallowConvCount());
                map.put("shallow_conv_cost", e.getShallowConvCost());
                map.put("deep_conv_count", e.getDeepConvCount());
                map.put("deep_conv_cost", e.getDeepConvCost());
                map.put("conv_num_by_impression", e.getConvNumByImpression());

                String openLogRequestUri = map.createOpenLogRequestUri(properties.getOpenLogRequestDomain());
                openLogClient.asyncRequest(openLogRequestUri);
            });
        }
    }
}
