package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;

import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * @author allen
 * @date 2022-10-18
 * @since 1.0
 */
public class ListenerKey {

    static final int ONE_DAY_SEC = TypeHelper.castToInt(Duration.ofDays(1).getSeconds());

    public interface Field {
        /**
         * 入口点击数
         */
        String CLICK = "click";
        /**
         * 转化回传成功数
         */
        String FEEDBACK_SUCCESS = "feedback_success";
        /**
         * 实际接收到的转化数
         */
        String RECEIVERS = "receivers";
        /**
         * 扣量数（待回传的数量）
         */
        String MINUS = "minus";
        /**
         * 补量数，非转化补量数，转化队列不足时从点击队列里回传的
         */
        String PLUS = "plus";
        /**
         * 转化补量数，指从扣下的转化队列里回传的
         */
        String PLUS_CONV = "plus_conv";
        /**
         * 扣量总数（累计）
         */
        String MINUS_TOTAL = "minus_total";
    }

    public static KeyGenerator hashData(String dimension) {
        return () -> KeyBuilder.build("rtb", "conv", "DATA", getDate(), dimension);
    }

    public static KeyGenerator hashDataApp(String dimension, String app) {
        return () -> KeyBuilder.build("rtb", "conv", "APP_DATA", getDate(), dimension, app);
    }

    public static KeyGenerator setsMap(String tagid, String adGroupId) {
        return () -> KeyBuilder.build("rtb", "conv", "MAP", getDate(), tagid, adGroupId);
    }

    private static String getDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }
}
