package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioClickEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import java.util.Objects;

/**
 * @author allen
 * @date 2022-10-18
 * @since 1.0
 */
public class RatioClickEventListener implements EventListener<RatioClickEvent> {

    private final Updater updater;
    private final Counter counter;

    public RatioClickEventListener(Updater updater, Counter counter) {
        this.updater = updater;
        this.counter = counter;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(RatioClickEvent event) {
        RatioControl control = event.getControl();
        RatioControlConfig config = control.getConfig();
        String dimension = config.getDimension();
        String tagid = config.getTagId();
        String adGroupId = event.getAdGroupId();
        String app = event.getApp();

        counter.hincrementByAndGet(ListenerKey.hashData(Objects.toString(config.getHitConfigId())), ListenerKey.Field.CLICK, 1, ListenerKey.ONE_DAY_SEC);
        counter.hincrementByAndGet(ListenerKey.hashData(dimension), ListenerKey.Field.CLICK, 1, ListenerKey.ONE_DAY_SEC);
        counter.hincrementByAndGet(ListenerKey.hashDataApp(dimension, app), ListenerKey.Field.CLICK, 1, ListenerKey.ONE_DAY_SEC);

        updater.supdate(ListenerKey.setsMap(tagid, adGroupId), ListenerKey.ONE_DAY_SEC, app);
    }
}
