package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioDeductionEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import java.util.Objects;

/**
 * 扣量总数计数器
 *
 * @author allen
 * @date 2022-11-09
 * @since 1.0
 */
public class RatioDeductionEventListener implements EventListener<RatioDeductionEvent> {

    private final Counter counter;

    public RatioDeductionEventListener(Counter counter) {
        this.counter = counter;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(RatioDeductionEvent event) {
        RatioControl control = event.getControl();
        RatioControlConfig config = control.getConfig();
        String dimension = config.getDimension();
        String app = event.getApp();

        counter.hincrementByAndGet(ListenerKey.hashData(Objects.toString(config.getHitConfigId())), ListenerKey.Field.MINUS_TOTAL, 1, ListenerKey.ONE_DAY_SEC);
        counter.hincrementByAndGet(ListenerKey.hashData(dimension), ListenerKey.Field.MINUS_TOTAL, 1, ListenerKey.ONE_DAY_SEC);
        counter.hincrementByAndGet(ListenerKey.hashDataApp(dimension, app), ListenerKey.Field.MINUS_TOTAL, 1, ListenerKey.ONE_DAY_SEC);
    }
}
