package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioPlusEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import java.util.Objects;

/**
 * @author allen
 * @date 2022-10-18
 * @since 1.0
 */
public class RatioPlusEventListener implements EventListener<RatioPlusEvent> {

    private final Counter counter;

    public RatioPlusEventListener(Counter counter) {
        this.counter = counter;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(RatioPlusEvent event) {
        RatioControl control = event.getControl();
        RatioControlConfig config = control.getConfig();
        String dimension = config.getDimension();
        String app = event.getApp();

        if (event.isFromClick()) {
            counter.hincrementByAndGet(ListenerKey.hashData(Objects.toString(config.getHitConfigId())), ListenerKey.Field.PLUS, 1, ListenerKey.ONE_DAY_SEC);
            counter.hincrementByAndGet(ListenerKey.hashData(dimension), ListenerKey.Field.PLUS, 1, ListenerKey.ONE_DAY_SEC);
            counter.hincrementByAndGet(ListenerKey.hashDataApp(dimension, app), ListenerKey.Field.PLUS, 1, ListenerKey.ONE_DAY_SEC);
        } else {
            counter.hincrementByAndGet(ListenerKey.hashData(Objects.toString(config.getHitConfigId())), ListenerKey.Field.PLUS_CONV, 1, ListenerKey.ONE_DAY_SEC);
            counter.hincrementByAndGet(ListenerKey.hashData(dimension), ListenerKey.Field.PLUS_CONV, 1, ListenerKey.ONE_DAY_SEC);
            counter.hincrementByAndGet(ListenerKey.hashDataApp(dimension, app), ListenerKey.Field.PLUS_CONV, 1, ListenerKey.ONE_DAY_SEC);
        }
    }
}
