package com.bxm.adscounter.rtb.common.data;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 查询rtb库参数
 * </p>
 *
 * @author tangxiao
 * @since 2023-01-06
 */
@Data
@AllArgsConstructor
@Builder
public class QueryParam implements Serializable {

    /**
     * 日期，格式 yyyyMMDD
     */
    private String date;

    /**
     * 小时数
     */
    private String hour;

    private List<String> adGroupId;

    private String appKey;

    private String business;

    private String positionId;

    /**
     * 查询行为，1.活动参与 2.券点击
     */
    private Integer action;

    /**
     * 广告id
     */
    private String adId;

    private String startTime;
    private String endTime;

    public String toSimpleString() {
        return "QueryParam{" +
                "date=" + date +
                ", hour=" + hour +
                ", adGroupId=" + adGroupId +
                ", appKey=" + appKey +
                ", business=" + business +
                '}';
    }
}