package com.bxm.adscounter.rtb.common.feedback;

import com.bxm.adscounter.rtb.common.utils.PositionRTBUtils;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author allen
 * @date 2022-12-19
 * @since 1.0
 */
public enum ActionType {

    /**
     * 活动参与
     */
    ACTIVITY_ATTEND("1"),
    /**
     * 活动复参
     */
    ACTIVITY_REATTEND("2"),
    /**
     * 广告券点击
     */
    TICKET_CLICK("3"),
    /**
     * 广告券回传
     */
    TICKET_CONVERSION("4");

    private final String value;

    ActionType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static ActionType of(KeyValueMap keyValueMap, PositionRtb config) {
        String mt = keyValueMap.getFirst(Inads.Param.MT);
        boolean isAdClick = StringUtils.equalsIgnoreCase(mt, Inads.Mt.AdClick.original());
        boolean isAdConversion = StringUtils.equalsIgnoreCase(mt, Inads.Mt.AdConversion.original());
        if (isAdClick) {
            return TICKET_CLICK;
        }
        if (isAdConversion) {
            return TICKET_CONVERSION;
        }
        if (Objects.isNull(config)) {
            return null;
        }
        boolean isActivityAttend = StringUtils.equalsIgnoreCase(mt, Inads.Mt.ActivityAttend.original());
        if (!isActivityAttend) {
            return null;
        }
        // 活动浅层
        String activityOne = config.getActivityOne();
        // 活动深层
        String activityTwo = config.getActivityTwo();
        if (StringUtils.equals(activityOne, PositionRTBUtils.ACTIVITY_ATTEND) || StringUtils.equals(activityTwo, PositionRTBUtils.ACTIVITY_ATTEND)) {
            return ACTIVITY_ATTEND;
        }
        if (StringUtils.equals(activityOne, PositionRTBUtils.ACTIVITY_REPEAT_ATTEND) || StringUtils.equals(activityTwo, PositionRTBUtils.ACTIVITY_REPEAT_ATTEND)) {
            return ACTIVITY_REATTEND;
        }
        return null;
    }
}
