package com.bxm.adscounter.rtb.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.ClickTracker;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.Objects;

/**
 * 继承 AbstractHttpRtbIntegration，实现了 {@link ClickTracker} 接口。
 *
 * @author allen
 * @date 2022-07-20
 * @since 1.0
 */
@Slf4j
public abstract class AbstractClickTrackerRtbIntegration extends AbstractHttpRtbIntegration implements ClickTracker {

    private Fetcher fetcher;
    private Updater updater;
    private PositionRtbService positionRtbService;

    public AbstractClickTrackerRtbIntegration(RtbConfig config) {
        super(config);
    }

    public AbstractClickTrackerRtbIntegration(RtbConfig config, HttpClient httpClient) {
        super(config, httpClient);
    }

    @Autowired
    public void setFetcher(@Qualifier("rtbJedisFetcher") Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Autowired
    public void setUpdater(@Qualifier("rtbJedisUpdater") Updater updater) {
        this.updater = updater;
    }

    @Autowired
    public void setPositionRtbService(PositionRtbService positionRtbService) {
        this.positionRtbService = positionRtbService;
    }

    @Override
    public void saveClickTracker(KeyValueMap clickTrackerKeyValueMap) {
        if (!saveIfNecessary(clickTrackerKeyValueMap)) {
            return;
        }
        String clickId = getClickId(clickTrackerKeyValueMap);
        if (StringUtils.isBlank(clickId)) {
            return;
        }
        updater.update(createKey(clickId), clickTrackerKeyValueMap, 24 * 60 * 60);
    }

    @Override
    public KeyValueMap getClickTracker(String clickId) {
        return fetcher.fetch(createKey(clickId), KeyValueMap.class);
    }

    private boolean saveIfNecessary(KeyValueMap clickTrackerKeyValueMap) {
        if (forceSaveClickTracker()) {
            return true;
        }
        String tagId = clickTrackerKeyValueMap.getFirst(Common.RtbParam.TAGID);
        if (StringUtils.isNotBlank(tagId)) {
            PositionRtb config = positionRtbService.get(tagId);
            if (Objects.isNull(config)) {
                return false;
            }
            return config.isControlForAnyType();
        }

        if (log.isWarnEnabled()) {
            log.warn("{} - recommend integration 'tagid' on this click tracker url.", rtb());
        }
        return true;
    }
}
