package com.bxm.adscounter.rtb.common.impl.alipaydh;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayDataDataserviceAdConversionUploadRequest;
import com.alipay.api.response.AlipayDataDataserviceAdConversionUploadResponse;
import com.bxm.adscounter.integration.adsmedia.AdsmediaService;
import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceUrlVO;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Objects;


/**
 * 支付宝灯火 采用ip归因的方式
 * <p>
 * click_id在点击监测中，点击建聪链接如下：
 * https://openlog.bianxianmao.com/common/s.gif?mt=30&rtb_id=38&tagid=positionId&
 * oaid=__OAID_MD5__&idfa=__IDFA_MD5__&request=__REQUEST_ID__&ts=__TS__&os=__OS__&
 * c_id=__AD_ID__&ad_group_id=__GROUP_ID__&ad_plan_id=__PLAN_ID__&account_id=__PRINCIPAL_ID__
 * &click_id=__CALLBACK_EXT_INFO__&ip=__IP__&ua=__UA__
 * todo   2024-01-31 已经改为从点击里面获取
 * @author daill
 * @date 2023-11-02
 * @since 1.0
 */
@Slf4j
public class AlipayDHRtbIntegration extends AbstractClickTrackerRtbIntegration {


    private final Fetcher fetcher;
    private final AlipayDHConfig config;


    private final AdsmediaService adsmediaService;

    public AlipayDHRtbIntegration(AlipayDHConfig config, @Qualifier("rtbJedisFetcher") Fetcher fetcher, AdsmediaService adsmediaService) {
        super(config);
        this.fetcher = fetcher;
        this.config = config;
        this.adsmediaService = adsmediaService;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return clickTrackerKeyValueMap.getFirst(Common.Param.CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        /*String ip = clickEventLog.getFirst(Common.Param.IP);
        if (StringUtils.isNotBlank(ip)) {
            return fetcher.fetch(RedisKeyGenerator.strAlipaydhIpClickId(ip), String.class);
        }
        return Strings.EMPTY;*/
        return  UrlHelper.getFirstValueOfParamName(clickEventLog.getRef(), Common.Param.CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        /*String clickId = getClickIdOnInadsAdClickLog(request.getKeyValueMap());
        if (StringUtils.isNotBlank(clickId)) {
            KeyValueMap clickTracker = getClickTracker(clickId);
            return Optional.ofNullable(clickTracker)
                    .map(k -> k.getFirst(Common.Param.AD_GROUP_ID))
                    .orElse(StringUtils.EMPTY);
        }
        return Strings.EMPTY;*/
        return  UrlHelper.getFirstValueOfParamName(request.getReferrer(), Common.Param.AD_GROUP_ID);
    }

    @Override
    public FeedbackResponse doFeedback(FeedbackRequest request, int status) throws RtbIntegrationException {
        try {
            String eventType = request.getEventType();
            KeyValueMap keyValueMap = request.getKeyValueMap();
            //String ip = keyValueMap.getFirst(Common.Param.IP);
            String bxmId = keyValueMap.getFirst(Inads.Param.BXMID);
            String clickId = request.getClickId();
            if (StringUtils.isBlank(clickId)) {
                clickId = UriComponentsBuilder.fromUriString(request.getReferrer()).build().getQueryParams().getFirst(Common.Param.CLICK_ID);
            }
                    //getClickIdOnInadsAdClickLog(keyValueMap);
            String tagId = keyValueMap.getFirst(Inads.Param.TAGID);
            if (StringUtils.isBlank(clickId)) {
                throw new RtbIntegrationException(FailType.IllegalParameter,
                        String.format("Cannot found clickId. keyValueMap: %s", JSONObject.toJSONString(keyValueMap)));
            }
            String customerId = request.getConfig().getCustomerId();
            String token = request.getConfig().getToken();
            String sourceId=request.getConfig().getSourceId();
            //公钥 私钥 appid都是放在这个对象json里面
            String extend =request.getConfig().getExtend();
            String privateKey = null;
            String publicKey = null;
            String appId = null;
            if(StringUtils.isNotBlank(extend)){
                AlipayConfig alipayConfig = JsonHelper.convert(extend, AlipayConfig.class);
                appId=alipayConfig.getAppId();
                privateKey=alipayConfig.getPrivateKey();
                publicKey =alipayConfig.getPublicKey();
            }else {
                //兼容之前
                AlipayDHConfig.AlipayDHEnum alipayDHEnum =AlipayDHConfig.AlipayDHEnum.of(sourceId);
                appId=alipayDHEnum.getAppId();
                privateKey=alipayDHEnum.getPrivateKey();
                publicKey =alipayDHEnum.getPublicKey();
            }
            if (StringUtils.isBlank(appId) || StringUtils.isBlank(publicKey) || StringUtils.isBlank(privateKey)) {
                throw new RtbIntegrationException(FailType.IllegalParameter,
                        String.format("Cannot found appId/publicKey/privateKey keyValueMap: %s", JSONObject.toJSONString(keyValueMap)));
            }

            AlipayClient alipayClient = new DefaultAlipayClient(config.getUrl(),
                    appId, privateKey,
                    "json", "GBK",publicKey , "RSA2");
            AlipayDataDataserviceAdConversionUploadRequest alipayRequest = new AlipayDataDataserviceAdConversionUploadRequest();
              //默认
            String appendvalue = "{" +
                    "          \"key\":\"tinyapp_id\"," +
                    "          \"value\":\"" + appId + "\"" +
                    "}";
            //开始获取投放链接
            AppEntranceUrlVO  appEntranceUrlVO =adsmediaService.getUrl(tagId);
            if(Objects.isNull(appEntranceUrlVO)){
                throw new RtbIntegrationException(FailType.IllegalParameter,
                        String.format("nomal is null , tagId: %s Cannot found sourceId. keyValueMap: %s", tagId, JSONObject.toJSONString(keyValueMap)));
            }
            if (StringUtils.equalsIgnoreCase("425", eventType)) {
                appendvalue = "{" +
                        "          \"key\":\"conversion_target_url\"," +
                        "          \"value\":\"" + appEntranceUrlVO.getNormal() + "\"" +
                        "}";
           } else if (StringUtils.equalsIgnoreCase("426", eventType)) {
                //小程序开始拼接链接
                String finalUrl="alipays://platformapi/startapp?appId="+appId
                        +"&page=pages/preW/index" +UrlHelper.urlEncode("?url="+UrlHelper.urlEncode(appEntranceUrlVO.getNormal().split("&click_id")[0]));
                appendvalue = appendvalue + ",{" +
                        "          \"key\":\"conversion_target_url\"," +
                        "          \"value\":\"" + finalUrl + "\"" +
                        "}";
            }

            alipayRequest.setBizContent("{" +
                    "  \"biz_token\":\""+token+"\"," +
                    "  \"conversion_data_list\":[" +
                    "    {" +
                    "      \"source\":\"COMMON_TARGET\"," +
                    "      \"principal_tag\":\""+customerId+"\"," +
                    "      \"biz_no\":\"" + System.currentTimeMillis() + "\"," +
                    "      \"conversion_type\":\""+eventType+"\"," +
                    "      \"conversion_time\":" + System.currentTimeMillis() / 1000 + "," +
                    "      \"uuid_type\":\"PID\"," +
                    "      \"uuid\":\"2088UID\"," +
                    "      \"property_list\":[" +
                    appendvalue +
                 /*   "        {" +
                    "          \"key\":\"tinyapp_id\"," +
                    "          \"value\":\""+alipayDHEnum.getAppId()+"\"" +
                    "        }" +*/
                    "      ]," +
                    "      \"callback_ext_info\":\""+UrlHelper.urlDecode(clickId)+"\"" +
                    "    }" +
                    "  ]" +
                    "}");
            AlipayDataDataserviceAdConversionUploadResponse alipayResponse = alipayClient.execute(alipayRequest);
            if (alipayResponse.isSuccess()) {
               return this.convert(request,null);
            } else {
                FeedbackResponse feedbackResponse = new FeedbackResponse();
                feedbackResponse.setSuccess(false);
                feedbackResponse.setBody(JSON.toJSONString(alipayResponse));
                return feedbackResponse;
            }
        }catch (Exception e){
            throw new RtbIntegrationException(FailType.OtherException, e);
        }
    }

    @Override
    public Rtb rtb() {
        return Rtb.ALIPAY_DH;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        return null;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
    @Data
    private static class AlipayConfig {
        private String privateKey;
        private String publicKey;
        private String appId;
    }
    public static void main(String[] args) {
        AlipayDHConfig.AlipayDHEnum alipayDHEnum =AlipayDHConfig.AlipayDHEnum.of("5");
        String finalUrl="alipays://platformapi/startapp?appId="+alipayDHEnum.getAppId()
                +"&page=pages/preW/index" +UrlHelper.urlEncode("?url="+UrlHelper.urlDecode("https://i.hangzhouyiyao.com/activities?appKey=9589f21a5898482db619691afe0eabc7&appEntrance=3&business=money&click_id=__CALLBACK_EXT_INFO__&ad_group_id=__GROUP_ID__"));

        System.out.println(finalUrl);

        String url="http://47.98.242.33:19822/activities/?appKey=d3e539ff67104565ab7a27d1face582e&appEntrance=52&business=money&click_id=__CALLBACK_EXT_INFO__&ad_group_id=__GROUP_ID__";
        System.out.println(url);
        System.out.println(url.split("&click_id")[0]);

        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(url);
        builder.replaceQueryParam("click_id");
        builder.replaceQueryParam("ad_group_id");
        System.out.println(builder.build().toUriString());
    }

}
