package com.bxm.adscounter.rtb.common.impl.alipaylife;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.JsonHelper;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.springframework.http.MediaType;
import org.springframework.web.util.UriComponentsBuilder;

import java.nio.charset.StandardCharsets;

/**
 * @author daill
 * @date 2022-05-16
 * @since 1.0
 */
@Slf4j
public class AlipayLifeRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public AlipayLifeRtbIntegration(AlipayLifeConfig config) {
        super(config);
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "qcjParamStr";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();

        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String qcjParamStr = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams().getFirst(clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank(qcjParamStr)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        HttpPost post = new HttpPost(url);
        post.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_UTF8_VALUE);
        AlipayLifeRequest alipayLifeRequest = new AlipayLifeRequest().setQcjParamStr(qcjParamStr);
        post.setEntity(new StringEntity(JsonHelper.convert(alipayLifeRequest), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    public Rtb rtb() {
        return Rtb.AlipayLife;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return JsonHelper.convert(body, Response.class);
    }


    private static class Response extends FeedbackResponse {

        private String code;
        private String msg;
        private String data;

        @Override
        public boolean isSuccess() {
            return org.apache.commons.lang.StringUtils.equalsIgnoreCase("000000", code);
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getData() {
            return data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }

    @Data
    @Accessors(chain = true)
    private static class AlipayLifeRequest {

        private String qcjParamStr;
        private int event = 2;
    }
}
