package com.bxm.adscounter.rtb.common.impl.anyue;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;
import java.util.Objects;

/**
 * @author tangxiao
 * @date 2023-04-10
 * @since 1.0
 */
@Slf4j
public class AnYueRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public AnYueRtbIntegration(AnYueConfig config) {
        super(config);
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String eventType = request.getEventType();
        String clickId = request.getClickId();
        String referrer = request.getReferrer();

        MultiValueMap<String, String> queryParams = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams();
        String gaid = queryParams.getFirst("gaid");

        if (StringUtils.isBlank(eventType)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'eventType'.");
        }

        if (StringUtils.isBlank(clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'clickId'.");
        }

        if (StringUtils.isBlank(gaid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, String.format("Cannot found 'gaid' from referrer [%s].", referrer));
        }

        Map<String, Object> params = Maps.newHashMap();
        params.put("click_id", clickId);
        params.put("aid", gaid);
        params.put("call_event_type", eventType);
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    public Rtb rtb() {
        return Rtb.AnYue;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        Response response = JsonHelper.convert(body, Response.class);
        FeedbackResponse feedbackResponse =new FeedbackResponse();
        feedbackResponse.setSuccess(Objects.nonNull(response) && response.isSuccess());
        return feedbackResponse;
    }

    @Data
    private static class Response {
        private int code = -1;
        private String msg;
        private String data;

        public boolean isSuccess() {
            return code == 1;
        }
    }
}
