package com.bxm.adscounter.rtb.common.impl.baiduocpx;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import lombok.Data;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.util.UriComponentsBuilder;

import java.nio.charset.StandardCharsets;

/**
 * @author tangxiao
 * @date 2023-03-28
 * @since 1.0
 */
public class BaiduOcpxRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public BaiduOcpxRtbIntegration(BaiduOcpxConfig config) {
        super(config);
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String eventType = request.getEventType();
        String callBack = request.getClickId();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String akey = keyValueMap.getFirst("akey");

        if (StringUtils.isBlank(callBack)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'callback_url'.");
        }

        if (StringUtils.isBlank(akey)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'akey'.");
        }

        callBack = UrlHelper.urlDecode(callBack);

        String url = UriComponentsBuilder.fromUriString(callBack)
                .replaceQueryParam("a_type", eventType)
                .replaceQueryParam("a_value", 0)
                .replaceQueryParam("sign", sign(callBack, akey))
                .build()
                .toString();
        return new HttpGet(url.trim());
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        BaiduResponse response = JsonHelper.convert(body, BaiduResponse.class);
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(response != null && response.isSuccess());
        feedbackResponse.setBody(response != null ? response.getError_msg() : null);
        return feedbackResponse;
    }

    @Override
    public Rtb rtb() {
        return Rtb.BaiduOcpx;
    }

    private String sign(String callback, String akey) {
        String string = callback + akey;
        return DigestUtils.md5Hex(string.getBytes(StandardCharsets.UTF_8));
    }

    @Data
    public static class BaiduResponse {
        private String error_code;
        private String error_msg;

        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase("0", error_code);
        }
    }
}
