package com.bxm.adscounter.rtb.common.impl.ifeng;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.youku.MapStrUtil;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.id.random.RandomIdGenerator;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.crypto.AesCipher;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;

/**
 * @author tangxiao
 * @date 2023-01-28
 * @since 1.0
 */
@Slf4j
public class IfengRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public static final String CLICK_ID = "clickSign";
    public static final String AD_GROUP_ID = "adId";

    public IfengRtbIntegration(IfengConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.IFENG;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return clickTrackerKeyValueMap.getFirst(Common.Param.CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName(clickEventLog.getRef(), CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString(referrer).build();
        MultiValueMap<String, String> queryParams = build.getQueryParams();
        return queryParams.getFirst(AD_GROUP_ID);
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        // https://alidocs.dingtalk.com/i/nodes/2X3LRMZdxkAJpPLkaZowJGgrBYeOq5Ew?utm_source=tb&utm_medium=tb_task_attach
        String referrer = request.getReferrer();
        String eventType = request.getEventType();

        PositionRtb config = request.getConfig();
        String customerId = config.getCustomerId();
        String secretKey = config.getToken();
        String convertId = config.getSourceId();

        if (StringUtils.isBlank(customerId) || StringUtils.isBlank(secretKey) || StringUtils.isBlank(convertId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'customerId' or 'token' or 'sourceId' by PositionRtb Config.");
        }

        MultiValueMap<String, String> queryParams = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams();

        String clickSign = queryParams.getFirst("clickSign");
        String adId = queryParams.getFirst("adId");
        String creativeId = queryParams.getFirst("creativeId");

        if (StringUtils.isBlank(clickSign)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'clickSign' by referrer.");
        }

        if (StringUtils.isBlank(adId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'adId' by referrer.");
        }

        if (StringUtils.isBlank(creativeId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'creativeId' by referrer.");
        }

        String orderId = new RandomIdGenerator().next();
        LinkedHashMap<String, Object> signParams = Maps.newLinkedHashMap();
        signParams.put("orderId", orderId);
        signParams.put("clickSign", clickSign);
        signParams.put("customerId", customerId);
        signParams.put("convertType", eventType);
        signParams.put("adId", adId);
        signParams.put("creativeId", creativeId);

        String signParamStr = MapStrUtil.toStr(signParams);
        String encryptParamStr;

        try {
            byte[] encrypt = AesCipher.encrypt(secretKey.getBytes(),  signParamStr.getBytes());
            encryptParamStr = Base64.encodeBase64String(encrypt);
            // 替换斜杠
            encryptParamStr = StringUtils.replace(encryptParamStr, "/", "_");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new RtbIntegrationException(FailType.IllegalParameter, "Occur error in AES encrypt.");
        }

        HashMap<String, Object> params = Maps.newHashMap();
        params.put("args", encryptParamStr);
        params.put("convertId", convertId);
        String feedbackUrl = getFeedbackUrl();

        if (log.isInfoEnabled()) {
            log.info("[{}] - ifeng paramsStr: {} | secretKey: {}", orderId, signParamStr, secretKey);
        }

        feedbackUrl = OkHttpUtils.appendParams(feedbackUrl, params);
        return new HttpGet(feedbackUrl);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

}
