package com.bxm.adscounter.rtb.common.impl.jiguang;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;

/**
 * @author daill
 * @date 2022-05-16
 * @since 1.0
 */
@Slf4j
public class JiguangRtbIntegration extends AbstractClickTrackerRtbIntegration {

    private final JiguangConfig config;

    public JiguangRtbIntegration(JiguangConfig config) {
        super(config, createHttpClient());
        this.config = config;
    }

    private static CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectionRequestTimeout(1000).setConnectTimeout(1000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    @Override
    public Rtb rtb() {
        return Rtb.JiGuang;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return false;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "jcid";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String jcid = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams().getFirst(clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank(jcid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        Map<String, Object> params = Maps.newHashMap();
        params.put("product_id", config.getJiguangProductId());
        params.put("event", eventType);
        params.put("ts", String.valueOf(System.currentTimeMillis()));
        params.put("jcid", jcid);
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}
