package com.bxm.adscounter.rtb.common.impl.kuaikan;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.RtbConfig;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Maps;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;
import java.util.Objects;

/**
 * 快看
 *
 * @author allen
 * @date 2022-11-14
 * @since 1.0
 */
public class KuaiKanRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public KuaiKanRtbIntegration(RtbConfig config) {
        super(config);
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "callback";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = config.getUrl();
        String referrer = request.getReferrer();

        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String callback = UrlHelper.getFirstValueOfParamName(referrer, clickIdParameterNameOnReferrer);
        String convTime = Objects.toString(System.currentTimeMillis() / 1000);
        String convType = request.getEventType();

        Map<String, String> param = Maps.newTreeMap();
        param.put("callback", callback);
        param.put("convTime", convTime);
        param.put("convType", convType);

        String queryString = rawQueryString(param);
        String sign = DigestUtils.md5Hex(queryString + request.getConfig().getToken());
        param.put("sign", sign);
        param.put("callback", UrlHelper.urlEncode(callback));

        LinkedMultiValueMap<String, String> map = new LinkedMultiValueMap<>();
        param.forEach(map::add);

        String finalUrl = UriComponentsBuilder.fromUriString(url).queryParams(map).build().toString();
        return new HttpGet(finalUrl);
    }

    private String rawQueryString(Map<String, String> param) {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, String> entry : param.entrySet()) {
            str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        return StringUtils.removeEnd(str.toString(), "&");
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        JSONObject object = JSONObject.parseObject(body);
        String code = object.getString("code");
        FeedbackResponse response = new FeedbackResponse();
        response.setSuccess(StringUtils.equals("200", code));
        response.setBody(body);
        return response;
    }

    @Override
    public Rtb rtb() {
        return Rtb.KuaiKan;
    }
}
