package com.bxm.adscounter.rtb.common.impl.liuliangguo;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.springframework.http.MediaType;

import java.nio.charset.StandardCharsets;
import java.util.Objects;


@Slf4j
public class LiuLiangGuoRtbIntegration extends AbstractClickTrackerRtbIntegration {
    public static final String CLICK_ID = "state_json";

    public LiuLiangGuoRtbIntegration(LiuLiangGuoConfig config) {
        super(config);
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return clickTrackerKeyValueMap.getFirst(Common.Param.CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return  UrlHelper.getFirstValueOfParamName(clickEventLog.getRef(), CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        if (Objects.isNull(keyValueMap)) {
            return null;
        }
        return keyValueMap.getFirst(Inads.Param.TAGID);
    }
    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String eventType = request.getEventType();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String clickId   = UrlHelper.getFirstValueOfParamName(request.getReferrer(), CLICK_ID);
        if (StringUtils.isBlank(clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter,
                    String.format("Cannot found state_json. keyValueMap: %s", JSONObject.toJSONString(keyValueMap)));
        }

        Request request1=new Request();
        request1.setOrder_id(String.valueOf(System.currentTimeMillis()));
        request1.setStatus(eventType);
        request1.setState_json(clickId);

        HttpPost post = new HttpPost(url);
        post.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_UTF8_VALUE);
        post.setEntity(new StringEntity(JsonHelper.convert(request1), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    public Rtb rtb() {
        return Rtb.LIULIANGGUO;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return JsonHelper.convert(body, Response.class);
    }
    private static class Response extends FeedbackResponse {
        private String status;
        private String message;

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase("200", status);
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getMessage() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    @Data
    @Accessors(chain = true)
    private static class  Request {
        private String state_json;
        private String order_id;
        private String status;
    }
}
