package com.bxm.adscounter.rtb.common.impl.mangguo;

import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.logging.log4j.util.Strings;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;

/**
 * @author tangxiao
 * @date 2024-04-15
 * @since 1.0
 */
@Slf4j
public class MangGuoRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public static final String CLICK_ID = "callback";
    private final Fetcher fetcher;

    public MangGuoRtbIntegration(MangGuoConfig config, Fetcher fetcher) {
        super(config);
        this.fetcher = fetcher;
    }

    @Override
    public Rtb rtb() {
        return Rtb.MANGGUO;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return clickTrackerKeyValueMap.getFirst(CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        String key = clickEventLog.getIp() + clickEventLog.getUa();
        log.info("manguo ipua : {}", key);
        if (StringUtils.isNotBlank(key)) {
            return fetcher.fetch(RedisKeyGenerator.strMangguoIpUaClickId(key), String.class);
        }
        return Strings.EMPTY;
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        if (Objects.isNull(keyValueMap)) {
            return null;
        }
        return keyValueMap.getFirst(Inads.Param.TAGID);
    }

    @Override
    public boolean forceSaveClickTracker() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String eventType = request.getEventType();
        String callback = getClickIdOnInadsAdClickLog(keyValueMap);
        if (StringUtils.isBlank(callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'callback' by clickTracker.");
        }
        if (StringUtils.isBlank(eventType)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'eventType' by config.");
        }
        callback = StringUtils.replace(callback, "__EVENT_TYPE__", eventType);
        callback = StringUtils.replace(callback, "__CONV_TIME__", Objects.toString(System.currentTimeMillis() / 1000));
        return new HttpGet(callback);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

}
