package com.bxm.adscounter.rtb.common.impl.mintegral;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;

/**
 * @author daill
 * @date 2022-06-30
 * @since 1.0
 */
@Slf4j
public class MintegralRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public static final String CLICK_ID = "campuuid";

    public MintegralRtbIntegration(MintegralConfig config) {
        super(config);
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return clickTrackerKeyValueMap.getFirst(Common.Param.CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName(clickEventLog.getRef(), CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString(referrer).build();
        MultiValueMap<String, String> queryParams = build.getQueryParams();
        return queryParams.getFirst(CLICK_ID);
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        PositionRtb positionRtb = request.getConfig();
        String campuuid = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams().getFirst(CLICK_ID);
        if (StringUtils.isBlank(campuuid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, positionRtb.getPositionId() + "Cannot found 'campuuid' by referrer.");
        }
        String clickid = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams().getFirst("clickid");
        if (StringUtils.isBlank(clickid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, positionRtb.getPositionId() + "Cannot found 'clickid' by referrer.");
        }
        Map<String, Object> params = Maps.newHashMap();
        params.put("clickid", clickid);
        params.put("campuuid", campuuid);
        params.put("install_time", String.valueOf(System.currentTimeMillis()));
        params.put("event_name", eventType);
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    public Rtb rtb() {
        return Rtb.Mintegral;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return JsonHelper.convert(body, Response.class);
    }

    @Data
    private static class Response extends FeedbackResponse {

        private String ret;
        private String msg;

        @Override
        public boolean isSuccess() {
            return StringUtils.equals("0", ret);
        }
    }
}
