package com.bxm.adscounter.rtb.common.impl.mintegraloverseas;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;

/**
 * @author tangxiao
 * @date 2023-02-21
 * @since 1.0
 */
@Slf4j
public class MintegralOverseasRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public MintegralOverseasRtbIntegration(MintegralOverseasConfig config) {
        super(config);
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        MultiValueMap<String, String> queryParams = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams();
        String campuuid = queryParams.getFirst("campaign_id");
        if (StringUtils.isBlank(campuuid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'campaign_id' by referrer.");
        }
        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String clickid = queryParams.getFirst(clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank(clickid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }

        Map<String, Object> params = Maps.newHashMap();
        params.put("clickid", clickid);
        params.put("campuuid", campuuid);
        params.put("install_time", String.valueOf(System.currentTimeMillis()));
        params.put("event_name", eventType);
        params.put("gaid", queryParams.getFirst("gaid"));
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    public Rtb rtb() {
        return Rtb.MintegralOverseas;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return JsonHelper.convert(body, Response.class);
    }

    @Data
    private static class Response extends FeedbackResponse {

        private String error;
        private String success;

        @Override
        public boolean isSuccess() {
            return StringUtils.equals("0", error);
        }
    }
}
