package com.bxm.adscounter.rtb.common.impl.pc360;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.nio.charset.StandardCharsets;

/**
 * @author tangxiao
 * @date 2022-06-01
 * @since 1.0
 */
@Slf4j
public class Pc360RtbIntegration extends AbstractClickTrackerRtbIntegration {


    public Pc360RtbIntegration(Pc360Config config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.pc360;
    }


    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        PositionRtb positionRtb = request.getConfig();
        MultiValueMap<String, String> queryParams = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams();
        //搜索推广 拼接/移动搜索拼接：qhclickid
        String qhclickid = queryParams.getFirst("qhclickid");
        // 移动推广拼接：&impression_id=__impression_id__，
        String impression_id = queryParams.getFirst("impression_id");
        // 展示广告拼接：sourceid
        String sourceid = queryParams.getFirst("sourceid");
        // 关系对应  数据应用方 ：   customerId   ；
        // key :  token ；
        // secret : sourceId ；
        // jzqs:   extend
        String industry = positionRtb.getCustomerId();
        if (StringUtils.equalsIgnoreCase(IndustryEnum.WEB.getIndex(), industry)) {
            //ocpc_web_convert 【移动推广】 ：需要广告主在 360 点睛投放平台提供的落地页链接中，通过增加宏替换参数，如&impression_id=__impression_id__，
            if (StringUtils.isBlank(impression_id)) {
                throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'impression_id' by referrer.");
            }
        } else if (StringUtils.equalsIgnoreCase(IndustryEnum.ZS.getIndex(), industry)) {
            qhclickid = sourceid;
            if (StringUtils.isBlank(sourceid)) {
                throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sourceid' by referrer.");
            }
        } else {
            //qhclickid    ocpc_ps_convert 【PC 搜索推广】  ocpc_ms_convert 【移动搜索】
            if (StringUtils.isBlank(qhclickid)) {
                throw new RtbIntegrationException(FailType.IllegalParameter, " Cannot found 'qhclickid' by referrer.");
            }
        }

        Request360 request360 = new Request360();
        Data data = new Data();
        Data_detail data_detail = new Data_detail();
        data_detail.setEvent(eventType);
        data_detail.setJzqs(positionRtb.getExtend());
        data_detail.setImpression_id(impression_id);
        data_detail.setQhclickid(qhclickid);
        data_detail.setTrans_id(String.valueOf(System.currentTimeMillis()));
        data.setData_industry(industry);
        data.setData_detail(data_detail);
        request360.setData(data);
        String value = JsonHelper.convert(request360);
        HttpPost post = new HttpPost(url);
        post.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_UTF8_VALUE);
        post.addHeader("App-Key", positionRtb.getToken());
        //App-Sign：为上述 3.2 平台操作界面的 Secret 字符串连接 POSTDATA 做 md5 小写后的值
        post.addHeader("App-Sign", DigestUtils.md5Hex(positionRtb.getSourceId() + value));
        post.setEntity(new StringEntity(value, StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        return JsonHelper.convert(body, Response.class);
    }

    private static class Response extends FeedbackResponse {

        private String errno;
        private String error;

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase("0", errno);
        }

        public String getErrno() {
            return errno;
        }

        public void setErrno(String errno) {
            this.errno = errno;
        }

        public String getError() {
            return error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    private static class Request360 {
        private Pc360RtbIntegration.Data data;

        public Pc360RtbIntegration.Data getData() {
            return data;
        }

        public void setData(Pc360RtbIntegration.Data data) {
            this.data = data;
        }
    }

    private static class Data {
        private String data_industry;

        private Data_detail data_detail;

        public String getData_industry() {
            return data_industry;
        }

        public void setData_industry(String data_industry) {
            this.data_industry = data_industry;
        }

        public Data_detail getData_detail() {
            return data_detail;
        }

        public void setData_detail(Data_detail data_detail) {
            this.data_detail = data_detail;
        }
    }

    private static class Data_detail {
        private String impression_id;
        private String qhclickid;
        private String jzqs;
        private String event;
        private String trans_id;

        public String getImpression_id() {
            return impression_id;
        }

        public void setImpression_id(String impression_id) {
            this.impression_id = impression_id;
        }

        public String getQhclickid() {
            return qhclickid;
        }

        public void setQhclickid(String qhclickid) {
            this.qhclickid = qhclickid;
        }

        public String getJzqs() {
            return jzqs;
        }

        public void setJzqs(String jzqs) {
            this.jzqs = jzqs;
        }

        public String getEvent() {
            return event;
        }

        public String getTrans_id() {
            return trans_id;
        }

        public void setTrans_id(String trans_id) {
            this.trans_id = trans_id;
        }

        public void setEvent(String event) {
            this.event = event;
        }
    }
}

