package com.bxm.adscounter.rtb.common.impl.qimaoOcpx;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.integration.utils.HttpClientUtils;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.RtbConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.ssl.SSLContexts;
import org.springframework.web.util.UriComponentsBuilder;

import javax.net.ssl.SSLContext;

/**
 * 七猫小说媒体回传
 * @author lijingyu
 * @date 2023-08-29
 * @since 1.0
 */
@Slf4j
public class QiMaoOcpxIntegration extends AbstractClickTrackerRtbIntegration {

    public QiMaoOcpxIntegration(QiMaoOcpxConfig config) {
        super(config,createHttpClient(config));
    }

    public static HttpClient createHttpClient(RtbConfig config) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContexts.custom().setProtocol("TLSv1.2").build();
        } catch (Exception e) {
            log.error("error", e);
        }
        return HttpClientUtils.createHttpClient(config.getMaxTotal(), config.getDefaultMaxPerRoute(), config.getConnectionRequestTimeout(), config.getConnectTimeout(), config.getSocketTimeout(), sslContext);
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String eventType = request.getEventType();
        KeyValueMap keyValueMap = request.getKeyValueMap();

        String callback = keyValueMap.getFirst(Common.Param.CLICK_ID);

        if (StringUtils.isBlank(callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, String.format("Cannot found callback from keyValueMap. keyValueMap: %s", JSONObject.toJSONString(keyValueMap)));
        }

        String callbackUrl = UriComponentsBuilder.fromUriString(UrlHelper.urlDecode(callback))
                .replaceQueryParam("event_type", eventType)
                .replaceQueryParam("timestamp", System.currentTimeMillis())
                .build()
                .toString();

        return new HttpGet(callbackUrl);
    }

    @Override
    public Rtb rtb() {
        return Rtb.QiMaoOcpx;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return JsonHelper.convert(body, QiMaoResponse.class);

    }

    private static class QiMaoResponse extends FeedbackResponse {

        private int code = -1;
        private String message;

        @Override
        public boolean isSuccess() {
            return code == 0;
        }

        public int getCode() {
            return code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

}
