package com.bxm.adscounter.rtb.common.impl.ruishi;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;

/**
 * @author tangxiao
 * @date 2022-08-30
 * @since 1.0
 */
@Slf4j
public class RuishiRtbIntegration extends AbstractClickTrackerRtbIntegration {


    public RuishiRtbIntegration(RuishiConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.Ruishi;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return false;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "vlionclkid";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String referrer = request.getReferrer();
        String eventType = request.getEventType();

        MultiValueMap<String, String> queryParams = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams();
        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String vlionClkId = queryParams.getFirst(clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank(vlionClkId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }

        Map<String, Object> params = Maps.newHashMap();
        params.put("e", vlionClkId);
        params.put("eventtype", eventType);

        String feedbackUrl = getFeedbackUrl();
        feedbackUrl = OkHttpUtils.appendParams(feedbackUrl, params);
        return new HttpGet(feedbackUrl);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

}
