package com.bxm.adscounter.rtb.common.impl.souhu;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;

/**
 * @author daill
 * @date 2022-08-22
 * @since 1.0
 */
@Slf4j
public class SouHuRtbIntegration extends AbstractClickTrackerRtbIntegration {

    private final SouHuConfig config;

    public SouHuRtbIntegration(SouHuConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "shcallback";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        PositionRtb positionRtb = request.getConfig();
        String eventType = request.getEventType();

        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String shcallback = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams().getFirst(clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank(shcallback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, positionRtb.getPositionId() + "： Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        Map<String, Object> params = Maps.newHashMap();
        params.put("shcallback", shcallback);
        params.put("event_type", eventType);
        params.put("timestamp", System.currentTimeMillis());
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    public Rtb rtb() {
        return Rtb.SouHu;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        if (StringUtils.equalsIgnoreCase("success", body)) {
            feedbackResponse.setSuccess(true);
        } else {
            feedbackResponse.setSuccess(false);
        }

        return feedbackResponse;
    }


 /*   @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }*/
}
