package com.bxm.adscounter.rtb.common.impl.wyyd;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;

/**
 * @author daill
 * @date 2022-05-16
 * @since 1.0
 */
@Slf4j
public class WyydRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public WyydRtbIntegration(WyydConfig config) {
        super(config);
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "ext_youdao";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();

        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String convExt = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams().getFirst(clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank(convExt)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }

        Map<String, Object> params = Maps.newHashMap();
        params.put("conv_ext", convExt);
        params.put("conv_action", eventType);
        params.put("conv_time", String.valueOf(System.currentTimeMillis()));
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    public Rtb rtb() {
        return Rtb.Youdao;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return JsonHelper.convert(body, Response.class);
    }


    private static class Response extends FeedbackResponse {
        private String code;
        private String msg;

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase("success", code);
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}
